unit Unit1;

interface
{ $DEFINE OLE}
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, EmapaLocalizeCOM_TLB, EmapaLocalizeCOM, EmapaLocalizeCOMClientImpl,
  ComCtrls, Spin, JvExControls, JvComponent, JvColorBox, JvColorButton;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    btnLeft: TButton;
    btnRight: TButton;
    btnTop: TButton;
    bnBottom: TButton;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    edtVal: TEdit;
    btnAppHeightGet: TButton;
    btnAppHeightSet: TButton;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    btnAppWidthSet: TButton;
    btnAppWidthGet: TButton;
    GroupBox6: TGroupBox;
    btnAppLeftSet: TButton;
    btnAppLeftGet: TButton;
    GroupBox7: TGroupBox;
    btnAppTopSet: TButton;
    btnAppTopGet: TButton;
    GroupBox8: TGroupBox;
    btnMapWidth: TButton;
    btnMapHeight: TButton;
    btnbringToFront: TButton;
    btnSendToBack: TButton;
    btnShowHide: TButton;
    GroupBox9: TGroupBox;
    tbrZoomLevel: TTrackBar;
    btnGetZoomLevel: TButton;
    GroupBox10: TGroupBox;
    btnQuitOnReleaseNo: TButton;
    btnQuitOnReleaseYes: TButton;
    GroupBox11: TGroupBox;
    btnGetFileName: TButton;
    btnOpenFile: TButton;
    btnCloseObjects: TButton;
    GroupBox12: TGroupBox;
    edtX: TEdit;
    edty: TEdit;
    edtLa: TEdit;
    edtLo: TEdit;
    btnConvertToBitmap: TButton;
    btnConvertToLoLa: TButton;
    btnStrFieldCount: TButton;
    edtStrFieldName: TEdit;
    cbStrFieldInfo: TCheckBox;
    btnStrFieldAdd: TButton;
    btnStrFieldRemove: TButton;
    btnStrFieldSet: TButton;
    sedStrFieldItem: TSpinEdit;
    btnStrFieldGet: TButton;
    btnStrFieldClear: TButton;
    btnNumFieldCount: TButton;
    edtNumFieldName: TEdit;
    cbNumFieldInfo: TCheckBox;
    btnNumFieldAdd: TButton;
    btnNumFieldRemove: TButton;
    btnNumFieldSet: TButton;
    sedNumFieldItem: TSpinEdit;
    btnNumFieldGet: TButton;
    btnNumFieldClear: TButton;

    gbxIcons: TGroupBox;
    btnIconsCount: TButton;
    btnIconsAdd: TButton;
    btnIconsRemove: TButton;
    sedtIconsIndex: TSpinEdit;
    lblIconsIndex: TLabel;
    btnIconsClear: TButton;
    btnIconsGet: TButton;
    btnIconsSet: TButton;
    sedtIconID: TSpinEdit;
    lblIconsId: TLabel;
    lblIconsFile: TLabel;
    lbliconsTransparent: TLabel;
    cbtnIconsTransparentColor: TJvColorButton;
    edtIconsFile: TEdit;
    odIcons: TOpenDialog;
    gbxLocalizeCollection: TGroupBox;
    btnLocalizeCollectionCreate: TButton;
    btnLocalizeCollectionDrop: TButton;
    btnlocalizeCollectionLocalzie: TButton;
    btnLocalizaCollectionSampleDaat: TButton;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnTopClick(Sender: TObject);
    procedure bnBottomClick(Sender: TObject);
    procedure btnLeftClick(Sender: TObject);
    procedure btnRightClick(Sender: TObject);
    procedure btnAppHeightGetClick(Sender: TObject);
    procedure btnAppHeightSetClick(Sender: TObject);
    procedure btnAppWidthSetClick(Sender: TObject);
    procedure btnAppWidthGetClick(Sender: TObject);
    procedure btnAppLeftGetClick(Sender: TObject);
    procedure btnAppLeftSetClick(Sender: TObject);
    procedure btnAppTopSetClick(Sender: TObject);
    procedure btnAppTopGetClick(Sender: TObject);
    procedure btnMapWidthClick(Sender: TObject);
    procedure btnMapHeightClick(Sender: TObject);
    procedure btnSendToBackClick(Sender: TObject);
    procedure btnbringToFrontClick(Sender: TObject);
    procedure btnShowHideClick(Sender: TObject);
    procedure tbrZoomLevelChange(Sender: TObject);
    procedure btnGetZoomLevelClick(Sender: TObject);
    procedure btnQuitOnReleaseYesClick(Sender: TObject);
    procedure btnQuitOnReleaseNoClick(Sender: TObject);
    procedure btnGetFileNameClick(Sender: TObject);
    procedure btnCloseObjectsClick(Sender: TObject);
    procedure btnOpenFileClick(Sender: TObject);
    procedure btnConvertToBitmapClick(Sender: TObject);
    procedure btnConvertToLoLaClick(Sender: TObject);
    procedure btnStrFieldCountClick(Sender: TObject);
    procedure btnStrFieldAddClick(Sender: TObject);
    procedure btnStrFieldRemoveClick(Sender: TObject);
    procedure btnStrFieldSetClick(Sender: TObject);
    procedure btnStrFieldGetClick(Sender: TObject);
    procedure btnStrFieldClearClick(Sender: TObject);
    procedure btnNumFieldCountClick(Sender: TObject);
    procedure btnNumFieldAddClick(Sender: TObject);
    procedure btnNumFieldRemoveClick(Sender: TObject);
    procedure btnNumFieldSetClick(Sender: TObject);
    procedure btnNumFieldGetClick(Sender: TObject);
    procedure btnNumFieldClearClick(Sender: TObject);
    procedure btnIconsCountClick(Sender: TObject);
    procedure btnIconsRemoveClick(Sender: TObject);
    procedure btnIconsClearClick(Sender: TObject);
    procedure btnIconsGetClick(Sender: TObject);
    procedure btnIconsSetClick(Sender: TObject);
    procedure btnIconsAddClick(Sender: TObject);
    procedure btnLocalizeCollectionCreateClick(Sender: TObject);
    procedure btnLocalizeCollectionDropClick(Sender: TObject);
    procedure btnlocalizeCollectionLocalzieClick(Sender: TObject);
    procedure btnLocalizaCollectionSampleDaatClick(Sender: TObject);
  private
    FLocalizeCollection : ILocalizeCollection;
    {$IFDEF OLE}
      Ole : OleVariant;
    {$ELSE OLE}
      Ole : LocalizeApp;
    {$ENDIF OLE}
    FSinkCookie : Longint;
    { Private declarations }
    procedure DoMouseDown(Longitude: VARIANT; Latitude: VARIANT; Action: ActionEnum; CollectObj: IReportCollection; GeoInformation: IGeoInformation);
  public
    procedure InfoOleObject(AInfoObjectResult: TDegeocodeAtPointDatabaseResult);
    { Public declarations }
  end;
var
  Form1: TForm1;
implementation

{$R *.dfm}
uses ComObj, Math;
procedure TForm1.InfoOleObject(AInfoObjectResult: TDegeocodeAtPointDatabaseResult);
begin
  Memo1.Lines.Add('-------------------------------------------------------');
  Memo1.Lines.Add('Category : '+AInfoObjectResult.Category);
  Memo1.Lines.Add('Name : '+AInfoObjectResult.Name);
  Memo1.Lines.Add('ID : '+IntToStr(AInfoObjectResult.ID));
  Memo1.Lines.Add('FoundLength : '+FloatToStr(AInfoObjectResult.FoundLength));
  Memo1.Lines.Add('Longitude : '+FloatToStr(AInfoObjectResult.FoundPoint.Longitude));
  Memo1.Lines.Add('Latitude : '+FloatToStr(AInfoObjectResult.FoundPoint.Latitude));
  Memo1.Lines.Add('-------------------------------------------------------');
  Memo1.Lines.Add('');
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  LSink : TDisplLocalizeCOMSink;
begin
  LSink := TDisplLocalizeCOMSink.Create;
  LSink.OnGetInfObject := InfoOleObject;

  LSink.OnMouseClickEvent := DoMouseDown;
  {$IFDEF OLE}
    Ole := CreateOleObject('EmapaLocalizeCOM.LocalizeApp')as ILocalizeApp;
    InterfaceConnect(OLE, IID_ILocalizeApp, LSink, FSinkCookie);
  {$ELSE}
    Ole := CreateComObject(CLASS_LocalizeApp)as ILocalizeApp;
    InterfaceConnect(Ole, DIID_DispILocalizeInfo, LSink, FSinkCookie);
  {$ENDIF}
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  {$IFDEF OLE}
    InterfaceDisconnect(Ole, IID_ILocalizeApp, FSinkCookie);
    Ole := Unassigned;
  {$ELSE}
    InterfaceDisconnect(Ole, IID_ILocalizeApp, FSinkCookie);
  {$ENDIF}
end;

procedure TForm1.btnTopClick(Sender: TObject);
begin
  Ole.TopPanelVisible := not Ole.TopPanelVisible;
end;

procedure TForm1.bnBottomClick(Sender: TObject);
begin
  Ole.BottomPanelVisible := not Ole.BottomPanelVisible;
end;

procedure TForm1.btnLeftClick(Sender: TObject);
begin
  Ole.LeftPanelVisible := not Ole.LeftPanelVisible;
end;

procedure TForm1.btnRightClick(Sender: TObject);
begin
  Ole.RightPanelVisible := not Ole.RightPanelVisible;
end;

procedure TForm1.btnAppHeightGetClick(Sender: TObject);
begin
  edtVal.Text := IntToStr(Ole.Height);
end;

procedure TForm1.btnAppHeightSetClick(Sender: TObject);
begin
  Ole.Height := StrToInt(edtVal.Text);
end;

procedure TForm1.btnAppWidthSetClick(Sender: TObject);
begin
  Ole.Width := StrToInt(edtVal.Text);
end;

procedure TForm1.btnAppWidthGetClick(Sender: TObject);
begin
  edtVal.Text := IntToStr(Ole.Width);
end;

procedure TForm1.btnAppLeftGetClick(Sender: TObject);
begin
  edtVal.Text := IntToStr(Ole.Left);
end;

procedure TForm1.btnAppLeftSetClick(Sender: TObject);
begin
  Ole.Left := StrToInt(edtVal.Text);
end;

procedure TForm1.btnAppTopSetClick(Sender: TObject);
begin
  Ole.Top := StrToInt(edtVal.Text);
end;

procedure TForm1.btnAppTopGetClick(Sender: TObject);
begin
  edtVal.Text := IntToStr(Ole.Top);
end;

procedure TForm1.btnMapWidthClick(Sender: TObject);
begin
  edtVal.Text := IntToStr(Ole.MapWidth);
end;

procedure TForm1.btnMapHeightClick(Sender: TObject);
begin
  edtVal.Text := IntToStr(Ole.MapHeight);
end;

procedure TForm1.btnSendToBackClick(Sender: TObject);
begin
  Ole.SendToBack;
end;

procedure TForm1.btnbringToFrontClick(Sender: TObject);
begin
  Ole.BringToFront;
end;

procedure TForm1.btnShowHideClick(Sender: TObject);
begin
  Ole.Visible := not Ole.Visible;
end;

procedure TForm1.tbrZoomLevelChange(Sender: TObject);
begin
  Ole.ZoomLevel := tbrZoomLevel.Position;
end;

procedure TForm1.btnGetZoomLevelClick(Sender: TObject);
begin
  ShowMessage(IntToStr(Ole.ZoomLevel));
end;

procedure TForm1.btnQuitOnReleaseYesClick(Sender: TObject);
begin
 Ole.QuitOnRelease := True;
end;

procedure TForm1.btnQuitOnReleaseNoClick(Sender: TObject);
begin
  Ole.QuitOnRelease := False;
end;

procedure TForm1.btnGetFileNameClick(Sender: TObject);
begin
  ShowMessage(Ole.ObjectFileName);
end;

procedure TForm1.btnCloseObjectsClick(Sender: TObject);
begin
  Ole.CloseFile;
end;

procedure TForm1.btnOpenFileClick(Sender: TObject);
begin
  with TOpenDialog.Create(self) do
  try
    if Execute then
    begin
      if FileExists(FileName) then
        Ole.OpenFile(FileName);
    end;
  finally
    Free;
  end;
end;

procedure TForm1.btnConvertToBitmapClick(Sender: TObject);
var
  i,j: integer;
begin
  StrToFloat(edtLo.Text);
  StrToFloat(edtLa.Text);
  Ole.LonLatToBitmap(StrToFloat(edtLa.Text), StrToFloat(edtLo.Text), i, j);
  edtX.Text := IntToStr(i);
  edty.Text := IntToStr(j);
end;

procedure TForm1.btnConvertToLoLaClick(Sender: TObject);
var
  i,j: OleVariant;
begin
  Ole.BitmapToLonLat(StrToInt(edtX.Text), StrToInt(edtY.Text), i, j);
  edtLo.Text := FloatToStr(i);
  edtLa.Text := FloatToStr(j);
end;

procedure TForm1.btnStrFieldCountClick(Sender: TObject);
begin
  ShowMessage(IntToStr(Ole.LocalizeConfiguration.AdditionalStringEntriesCollection.Count))
end;

procedure TForm1.btnStrFieldAddClick(Sender: TObject);
var
  LVal : IAdditionalStringFieldEntry;
begin
  LVal := Ole.LocalizeConfiguration.AdditionalStringEntriesCollection.Add(edtStrFieldName.Text, cbStrFieldInfo.Checked, -1,-1);
  //LVal.Name := '2222';
  //LVal.ShowOnInfo := True;
end;

procedure TForm1.btnStrFieldRemoveClick(Sender: TObject);
begin
  Ole.LocalizeConfiguration.AdditionalStringEntriesCollection.Remove(sedStrFieldItem.Value);
end;

procedure TForm1.btnStrFieldSetClick(Sender: TObject);
var
  LVal : IAdditionalStringFieldEntry;
begin
   LVal := Ole.LocalizeConfiguration.AdditionalStringEntriesCollection.Item[sedStrFieldItem.Value];
  LVal.Name := edtStrFieldName.Text;
  LVal.ShowOnInfo := cbStrFieldInfo.Checked;
end;

procedure TForm1.btnStrFieldGetClick(Sender: TObject);
var
  LVal : IAdditionalStringFieldEntry;
begin
  LVal := Ole.LocalizeConfiguration.AdditionalStringEntriesCollection.Item[sedStrFieldItem.Value];
  edtStrFieldName.Text := LVal.Name;
  cbStrFieldInfo.Checked := LVal.ShowOnInfo;
end;

procedure TForm1.btnStrFieldClearClick(Sender: TObject);
begin
  Ole.LocalizeConfiguration.AdditionalStringEntriesCollection.Clear
end;

procedure TForm1.btnNumFieldCountClick(Sender: TObject);
begin
  ShowMessage(IntToStr(Ole.LocalizeConfiguration.AdditionalNumericEntriesCollection.Count))
end;

procedure TForm1.btnNumFieldAddClick(Sender: TObject);
var
  LVal : IAdditionalNumericFieldEntry;
begin
  LVal := Ole.LocalizeConfiguration.AdditionalNumericEntriesCollection.Add(edtNumFieldName.Text, cbNumFieldInfo.Checked, -1,-1);
  //LVal.Name := '2222';
  //LVal.ShowOnInfo := True;
end;

procedure TForm1.btnNumFieldRemoveClick(Sender: TObject);
begin
  Ole.LocalizeConfiguration.AdditionalNumericEntriesCollection.Remove(sedNumFieldItem.Value);
end;

procedure TForm1.btnNumFieldSetClick(Sender: TObject);
var
  LVal : IAdditionalNumericFieldEntry;
begin
  LVal := Ole.LocalizeConfiguration.AdditionalNumericEntriesCollection.Item[sedNumFieldItem.Value];
  LVal.Name := edtNumFieldName.Text;
  LVal.ShowOnInfo := cbNumFieldInfo.Checked;
end;

procedure TForm1.btnNumFieldGetClick(Sender: TObject);
var
  LVal : IAdditionalNumericFieldEntry;
begin
   LVal := Ole.LocalizeConfiguration.AdditionalNumericEntriesCollection.Item[sedNumFieldItem.Value];
  edtNumFieldName.Text := LVal.Name;
  cbNumFieldInfo.Checked := LVal.ShowOnInfo;
end;

procedure TForm1.btnNumFieldClearClick(Sender: TObject);
begin
  Ole.LocalizeConfiguration.AdditionalNumericEntriesCollection.Clear;
end;

procedure TForm1.btnIconsCountClick(Sender: TObject);
begin
  ShowMessage(IntToStr(Ole.LocalizeConfiguration.IconConfiguration.Count))
end;

procedure TForm1.btnIconsRemoveClick(Sender: TObject);
begin
  Ole.LocalizeConfiguration.IconConfiguration.Remove(sedtIconsIndex.Value);
end;

procedure TForm1.btnIconsClearClick(Sender: TObject);
begin
  Ole.LocalizeConfiguration.IconConfiguration.Clear;
end;

procedure TForm1.btnIconsGetClick(Sender: TObject);
var
  LVal : IIconEntry;
begin
  LVal := Ole.LocalizeConfiguration.IconConfiguration.Item[sedtIconsIndex.Value];
  edtIconsFile.Text := LVal.FileName;
  sedtIconID.Value := LVal.IconIndex;
  cbtnIconsTransparentColor.Color := LVal.TransparentColor;
end;               

procedure TForm1.btnIconsSetClick(Sender: TObject);
var
  LVal : IIconEntry;
begin
  LVal := Ole.LocalizeConfiguration.IconConfiguration.Item[sedtIconsIndex.Value];
  LVal.FileName := edtIconsFile.Text;
  LVal.IconIndex := sedtIconID.Value;
  LVal.TransparentColor := cbtnIconsTransparentColor.Color;
end;

procedure TForm1.btnIconsAddClick(Sender: TObject);
var
  LVal : IIconEntry;
begin
  with odIcons do
  begin
    if Execute and FileExists(FileName) then
    begin
      LVal := Ole.LocalizeConfiguration.IconConfiguration.Add(FileName, sedtIconID.Value, Unassigned, Unassigned);
    end;
  end;
end;

procedure TForm1.btnLocalizeCollectionCreateClick(Sender: TObject);
begin
  FLocalizeCollection := Ole.CreateLocalizeCollection;
end;

procedure TForm1.btnLocalizeCollectionDropClick(Sender: TObject);
begin
  if Assigned(FLocalizeCollection) then
    FLocalizeCollection := Nil;
end;

procedure TForm1.btnlocalizeCollectionLocalzieClick(Sender: TObject);
begin
  if Assigned(FLocalizeCollection) then
    Ole.LocalizeCollection(FLocalizeCollection, True);
end;

procedure TForm1.btnLocalizaCollectionSampleDaatClick(Sender: TObject);

var
  as1, an1 : Integer;
   procedure RandomPoints(ILObj : IPositionsCollection);
   var
     LObj : IPosition;
     LLo : real;
     LLa : real;
     I,J : Integer;
   begin
     for I:=0 to RandomRange(1,10) do
     begin
       LLo :=  RandomRange(1, 5000) /1000;
       LLa :=  RandomRange(1, 5000) /1000;
       LObj := ILObj.Add(18+LLo,53-LLa, 0, 0);
       LObj.ShowDescription := True;
       LObj.Description := 'Opis '+ IntToStr(RandomRange(1,10000));
       LObj.ShowName:= True;
       LObj.IconColor := RandomRange(-10000,10000);
       LObj.IconIndex := RandomRange(1,2);
       LObj.ShowIcon := True;
       LObj.IconIndex := RandomRange(1,2);
       for J:=1 To an1 do
         LObj.AdditionalNumericField[J]:=0;
       for J:=1 To as1 do
         LObj.AdditionalStringField[J]:=IntToStr(I)+'_ooo';
     end;
   end;

   procedure RandomData(ILObj : ILocalizeObject);
   begin
     Randomize;
     ILObj.EntID := RandomRange(1,100);
     ILObj.Name := 'ObjTest - '+IntToStr(ILObj.EntID);
     ILObj.ShowName := (RandomRange(1,100) mod 2) =1;
     ILObj.IconIndex := RandomRange(1,2);
     ILObj.IconColor := RandomRange(-10000,10000);
     ILObj.PathColor := RandomRange(-10000,10000);
     ILObj.PathWidth := RandomRange(1,100);
     ILObj.Size := RandomRange(1,100);
     ILObj.RemovePrevious := False;
     ILObj.PathWidth := RandomRange(1,100);
     RandomPoints(ILObj.Positions);
   end;
var
  ILObj : ILocalizeObject;
  I : Integer;
begin
  if not Assigned(FLocalizeCollection) then
    Exit;
  an1 := Ole.LocalizeConfiguration.AdditionalNumericEntriesCollection.Count;
  as1 := Ole.LocalizeConfiguration.AdditionalStringEntriesCollection.Count;
  for i:=0 to 10  do
  begin
    ILObj := FLocalizeCollection.Add(0,0);
    RandomData(ILObj);
  end;
end;

procedure TForm1.DoMouseDown(Longitude: VARIANT; Latitude: VARIANT; Action: ActionEnum; CollectObj: IReportCollection; GeoInformation: IGeoInformation);
var
  I : Integer;
begin
  Memo1.Lines.Add('-------------------MOUSE CLICK-------------------');
  Memo1.Lines.Add('Longitude : '+FloatToStr(Longitude));
  Memo1.Lines.Add('Latitude : '+ FloatToStr(Latitude));
  case Action of
    Info:
      Memo1.Lines.Add('Action : Info');
    Pan:
      Memo1.Lines.Add('Action : MoveMap');
    ZoomIn:
      Memo1.Lines.Add('Action : ZoomIn');
    ZoomOut:
      Memo1.Lines.Add('Action : ZoomOut');
  end;
  Memo1.Lines.Add('');
  Memo1.Lines.Add('---GeoInformation--');
  Memo1.Lines.Add('Country :'+GeoInformation.Country);
  Memo1.Lines.Add('County :'+GeoInformation.County);
  Memo1.Lines.Add('State :'+GeoInformation.State);
  Memo1.Lines.Add('Neighbourhood :'+GeoInformation.Neighbourhood);
  Memo1.Lines.Add('EntID :'+IntToStr(GeoInformation.EntID));
  Memo1.Lines.Add('---/GeoInformation--');
   Memo1.Lines.Add('');

  Memo1.Lines.Add('');
  Memo1.Lines.Add('---ReportCollection--');
  for I:=1 To CollectObj.Count do
  begin
    Memo1.Lines.Add('--Item_'+IntToStr(i));
    Memo1.Lines.Add('Name :'+CollectObj.Item[i].Name);
    Memo1.Lines.Add('EntID :'+IntToStr(CollectObj.Item[i].EntID));
    Memo1.Lines.Add('PositionInCollection :'+IntToStr(CollectObj.Item[i].PositionInCollection));
    Memo1.Lines.Add('Time :'+DateToStr(CollectObj.Item[i].Time));
    Memo1.Lines.Add('Country :'+CollectObj.Item[i].Country);
    Memo1.Lines.Add('County :'+CollectObj.Item[i].County);
    Memo1.Lines.Add('State :'+CollectObj.Item[i].State);
    Memo1.Lines.Add('Neighbourhood :'+CollectObj.Item[i].Neighbourhood);
  end;
  Memo1.Lines.Add('---/ReportCollection--');
  Memo1.Lines.Add('');
  Memo1.Lines.Add('------------------------------------------------');
end;

end.
